﻿using System;
using System.Collections.Generic;
using OOPLS;

public struct ZipCode : RadixSortKey
{
    int zip;
    public ZipCode(int zip)
    {
        this.zip = zip;
    }
    public int Radix { get { return 10; } }
    public int this[int i]
    {
        get
        {
            int digit = zip;
            while (--i > 0) digit /= 10;
            return digit % 10;
        }
    }
    public int DigitCount { get { return 5; } }
    public int Value { get { return zip; } }
}

public class PostalRecord : RadixSortElement<ZipCode>
{
    ZipCode zip;
    string name, address1, address2, city, state;
    public PostalRecord(string name, string address1,
                        string address2, string city,
                        string state, string zip)
    {
        this.name = name;
        this.address1 = address1;
        this.address2 = address2;
        this.city = city;
        this.state = state;
        this.zip = new ZipCode(Int32.Parse(zip));
    }
    public ZipCode Key
    {
        get { return zip; }
    }
}

public class RadixSortTester
{
    static string[,] trialData = {
            {"Zachariah Malachi", "101 Holy Lane", 
             "Apartment 3B", "Jerusalem", "GA", "35109"},
            {"Cody Kadiddlehopper", "5967 Old Horse Lane", 
             "", "Badlands", "KS", "50505"},
            {"Curtis Plemmons", "Route 7", "", 
             "Turkey Trot", "PA", "16678"},
            {"Melinda Jabbers", "11234 Fifth Avenue", "", 
             "Manhattan", "OK", "77789"},
            {"Smyrna Figs", "200 Locust Avenue", "", 
             "Richmond", "KY", "40475"},
            {"Allyson Krauts", "421 Mockingbird Lane", 
             "Box 277", "Nashville", "TN", "37205"}
        };
    public static void Main(string[] arg)
    {
        Queue<PostalRecord> mainQueue =
            new Queue<PostalRecord>();
        try
        {
            for (int i = 0; i < trialData.GetLength(0); ++i)
            {
                mainQueue.Enqueue(
                    new PostalRecord(
                        trialData[i, 0], trialData[i, 1],
                        trialData[i, 2], trialData[i, 3],
                        trialData[i, 4], trialData[i, 5]
                    )
                );
            }
            RadixSorter<ZipCode, PostalRecord>.sort(mainQueue);
        }
        catch (Exception e)
        {
            Console.WriteLine(e.ToString());
        }
        while (mainQueue.Count != 0)
        {
            PostalRecord record = mainQueue.Dequeue();
            Console.WriteLine(record.Key.Value);
        }
    }

}
